unit Barfrm;
{Warning: If the TBarcode component is not installed,
 You get an error message while loading this project!
 If this happens to You, You first have to close he project
 WITHOUT SAVING and read the documentation how
 to install TBarcode as a VCL-component.

 Documentation is in the files ENGLISH.DOC and DEUTSCH.DOC.

 If You have any problems installing or using TBarcode,
 please contact the author:
 Juergen Schlottke
 CIS-ID   100106,3034
 Internet 100106.3034@compuserve.com
 WWWeb    http://ourworld.compuserve.com/homepages/schlottke

 Please consider that my mother language is German and
 use simple words when asking me difficult questions!
 }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, ExtCtrls, Buttons,Barcode, BarHL,
  Menus;

type
  TDemoForm = class(TForm)
    RGModulewidth: TRadioGroup;
    RGCodetyp: TRadioGroup;
    CB_ZoomSize: TCheckBox;
    CB_HighDensity: TCheckBox;
    CB_WidthReduce: TCheckBox;
    CB_HumanReadable: TCheckBox;
    Edit1: TEdit;
    Edit2: TEdit;
    SE_HeightPerCent: TSpinEdit;
    Label1: TLabel;
    Label2: TLabel;
    PrintBtn: TBitBtn;
    ExitBtn: TButton;
    RGRotation: TRadioGroup;
    Label3: TLabel;
    Label4: TLabel;
    Barcode1: TBarcode;
    PopupMenu1: TPopupMenu;
    Printactualbarcode1: TMenuItem;
    Printbarcodeonthefly1: TMenuItem;
    Printinginmapmodemm1: TMenuItem;
    Labelprintingdemo1: TMenuItem;
    SaveDialog1: TSaveDialog;
    Copybarcodetoclipboard1: TMenuItem;
    SavebarcodetoBMPfile1: TMenuItem;
    Printrotatedbarcodes1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure Edit1Change(Sender: TObject);
    procedure Edit2Change(Sender: TObject);
    procedure SE_HeightPerCentChange(Sender: TObject);
    procedure RGCodetypClick(Sender: TObject);
    procedure RGModulewidthClick(Sender: TObject);
    procedure CB_HighDensityClick(Sender: TObject);
    procedure CB_ZoomSizeClick(Sender: TObject);
    procedure CB_WidthReduceClick(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure RGRotationClick(Sender: TObject);
    procedure CB_HumanReadableClick(Sender: TObject);
    procedure PrintBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure Printactualbarcode1Click(Sender: TObject);
    procedure SavebarcodetoBMPfile1Click(Sender: TObject);
    procedure Copybarcodetoclipboard1Click(Sender: TObject);
    procedure Printinginmapmodemm1Click(Sender: TObject);
    procedure Labelprintingdemo1Click(Sender: TObject);
    procedure Printrotatedbarcodes1Click(Sender: TObject);
    procedure Printbarcodeonthefly1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure PrintActualBarcode;
    procedure PrintOnTheFly;
    procedure PrintRotated;
    procedure PrintMapmodeLLMetric;
    procedure PrintLabelDemo;
    procedure SaveBMPfile;
    procedure Copy2Clipboard;
  public
    { Public-Deklarationen }
  end;

var
  DemoForm: TDemoForm;

implementation
uses Printers;
{$R *.DFM}



procedure TDemoForm.PrintBtnClick(Sender: TObject);
var point:TPoint;
begin
  getcursorpos(point);
  PopUpMenu1.Popup(point.x,point.y);
end;

procedure TDemoForm.ExitBtnClick(Sender: TObject);
begin
  Application.terminate;
end;

procedure TDemoForm.FormCreate(Sender: TObject);
begin
  SE_HeightPercent.value:=Barcode1.Bar_HeightperCent;
  RGModuleWidth.itemindex:=ord(Barcode1.Bar_ModuleWidth);
  RGCodetyp.itemindex:=ord(Barcode1.Bar_Codetype);
  CB_HighDensity.checked:=Barcode1.Bar_HighDensity;
  CB_ZoomSize.checked:=Barcode1.Bar_ZoomSize;
  CB_WidthReduce.checked:=Barcode1.Bar_WidthReduce;
  CB_HumanReadable.checked:=Barcode1.Bar_HumanReadable;
  Edit1.text:=Barcode1.Bar_Caption;
  Edit2.text:=Barcode1.Bar_CodeAddon;
end;

procedure TDemoForm.Edit1Change(Sender: TObject);
begin
  Barcode1.Bar_Caption:=Edit1.text;
end;


procedure TDemoForm.Edit2Change(Sender: TObject);
begin
  Barcode1.Bar_CodeAddon:=Edit2.text;
end;


procedure TDemoForm.SE_HeightPerCentChange(Sender: TObject);
begin
  Barcode1.Bar_HeightPercent:=SE_HeightPercent.value;
end;

procedure TDemoForm.RGCodetypClick(Sender: TObject);
begin
  Barcode1.Bar_CodeType:=btCodeTypes(RGCodetyp.itemindex);
end;

procedure TDemoForm.RGModulewidthClick(Sender: TObject);
begin
  Barcode1.Bar_Modulewidth:=btCodeSizes(RGModuleWidth.itemindex);
end;

procedure TDemoForm.RGRotationClick(Sender: TObject);
begin
  Barcode1.Bar_Rotation:=btCodeRotate(RGRotation.itemindex);
end;

procedure TDemoForm.CB_HighDensityClick(Sender: TObject);
begin
  Barcode1.Bar_HighDensity:=CB_HighDensity.checked;
end;

procedure TDemoForm.CB_ZoomSizeClick(Sender: TObject);
begin
  Barcode1.Bar_Zoomsize:=CB_ZoomSize.checked;
end;

procedure TDemoForm.CB_WidthReduceClick(Sender: TObject);
begin
  Barcode1.Bar_WidthReduce:=CB_WidthReduce.checked;
end;

procedure TDemoForm.CB_HumanReadableClick(Sender: TObject);
begin
  Barcode1.Bar_HumanReadable:=CB_HumanReadable.checked;
end;


procedure TDemoForm.FormPaint(Sender: TObject);
{You don't have to define a FormPaint procedure, this
 procedure will only show how to calculate output positions}
{var r:TRect;}
begin
  {If You want to see Barcode1 with a bounding box, remove
   the comment brackets from the following source lines}
(*
  {First print the Barcode in its own position to get dimensions}
  Barcode1.print(Canvas,Barcode1.left,Barcode1.top,@Point);
  {Width and height are returned in "Point" variable,
   now calculate the bounding box}
  R:=rect(Barcode1.left,Barcode1.top,Barcode1.left+Point.x,Barcode1.top+Point.y);
  {paint the bounding box}
  canvas.framerect(R);
  *)
end;

procedure TDemoForm.PrintActualBarcode;
{This print demo will use the barcode as shown in the form for printout}
var
  x,y,lineheight:Integer;
  xmm,ymm:Extended;
  Point:TPoint;
begin
  printer.begindoc;
  {Find out: How many device units are one mm}
  xmm:=getdevicecaps(Printer.Handle,logpixelsX)/25.4;
  ymm:=getdevicecaps(Printer.Handle,logpixelsY)/25.4;
  {Find out printing offset on page}
  escape(Printer.handle,Getprintingoffset,0,nil,@point);
  {Adjust printing offset, so output starts at the
   same coordinates on all printers}
  SetViewPortOrgEx(Printer.handle,-point.x,-point.y,nil);
  {Now Print the Barcode at}
  x:=round(50*Xmm);  {50mm from left}
  y:=round(60*Ymm);  {60mm from top}
  {Actual width and height of barcode are returned in "Point"}
  Barcode1.Print(Printer.canvas,x,y,@Point);
  x:=round(25*xmm);    {Set left:= 25mm}
  inc(y,Point.y);      {increment with height of barcode}
  inc(y,round(10*ymm));{increment 10mm}
  with Printer.canvas.font do
  begin
    name:='Arial';
    size:=12;
  end;
  {How many device units are one line printed with Arial-12}
  lineheight:=Printer.canvas.textheight('X');
  {Now print some lines of text}
  Printer.canvas.textout(x,y,'Top left corner of barcode should be placed at:');
  inc(y,lineheight);
  Printer.canvas.textout(x,y,'50mm from left, 60mm from top of page');
  inc(y,2*lineheight);
  If Barcode1.Bar_Zoomsize then
  begin
    Printer.canvas.textout(x,y,'Warning: With "Bar_Zoomsize:=true" Your barcodes might be bad!');
    inc(y,lineheight);
    Printer.canvas.textout(x,y,'Please use "Bar_Zoomsize:=false" for printing best barcodes!');
    inc(y,2*lineheight);
  end;
  If Barcode1.Bar_WidthReduce then
  begin
    Printer.canvas.textout(x,y,'"Warning: Bar_WidthReduce:=true"');
    inc(y,lineheight);
    Printer.canvas.textout(x,y,'This option should be used with dot-matrix and ink-jet printers only!');
    inc(y,lineheight);
    Printer.canvas.textout(x,y,'With laser printers You must use "Bar_WidthReduce:=false"!');
    inc(y,2*lineheight);
  end;
  Printer.canvas.textout(x,y,'The dimensions of the printed barcode are:');
  inc(y,lineheight);
  Printer.canvas.textout(x,y,format('%d device units (%2.1fmm) in X-direction',[point.x,point.x/xmm]));
  inc(y,lineheight);
  Printer.canvas.textout(x,y,format('%d device units (%2.1fmm) in Y-direction',[point.y,point.y/ymm]));
  printer.enddoc;
end;

procedure TDemoForm.Printactualbarcode1Click(Sender: TObject);
begin
  PrintActualBarcode;
end;

procedure TDemoForm.PrintOnTheFly;
{This print demo will create a barcode "on the fly" and
 use it for printer output. No visual object in the form needed.}
var
  x,y,lineheight:Integer;
  xmm,ymm:Extended;
  Point:TPoint;
  MyBarcode:TBarcode;
begin
  MyBarcode:=TBarcode.create(self); {Create TBarcode object!}
  With MyBarcode do {Set some default options}
  begin
    {Set a code as You like}
    Bar_Caption:='471112';
    {Set normal Height,
     this is default, but for demonstration purposes...}
    Bar_HeightPercent:=100;
    {No high density codes,
     this is default, but for demonstration purposes...}
    Bar_HighDensity:=false;
    {Set "Normal width" which is SC2,
     this is default, but for demonstration purposes...}
    Bar_Modulewidth:=SC2;
    {With Laserprinters always use Widthreduce:=false,
     this is default, but for demonstration purposes...}
    Bar_Widthreduce:=false;
    {While printing always use Bar_ZoomSize:=false,
     this is default, but for demonstration purposes...}
    Bar_ZoomSize:=false;
  end;
  printer.begindoc;
  {Find out: How many device units are one mm}
  xmm:=getdevicecaps(Printer.Handle,logpixelsX)/25.4;
  ymm:=getdevicecaps(Printer.Handle,logpixelsY)/25.4;
  {Find out printing offset on page}
  escape(Printer.handle,Getprintingoffset,0,nil,@point);
  {Adjust printing offset, so output starts at the
   same coordinates on all printers}
  SetViewPortOrgEx(Printer.handle,-point.x,-point.y,nil);
  Printer.Canvas.Font.Name:='Arial';
  Printer.Canvas.Font.Size:=12;
  lineheight:=Printer.Canvas.textheight('Ay');
  x:=round(25*xmm);
  y:=round(25*ymm);
  {EAN-8 demo}
  Printer.Canvas.Textout(x,y,'EAN-8-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=EAN_8;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {EAN-13 demo}
  Printer.Canvas.Textout(x,y,'EAN-13-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=EAN_13;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {UPC-A demo}
  Printer.Canvas.Textout(x,y,'UPC-A-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=UPC_A;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {UPC-E demo}
  Printer.Canvas.Textout(x,y,'UPC-E-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=UPC_E;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {CODE39 demo}
  Printer.Canvas.Textout(x,y,'Code 39-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=CODE39;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y+round(10*ymm));
  {Code 2/5 interleaved demo}
  Printer.Canvas.Textout(x,y,'Code 2/5 interleaved-Demo:');
  inc(y,lineheight);
  MyBarcode.Bar_Codetype:=Code25i;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  printer.enddoc;
  MyBarcode.free; {free the created TBarcode object!}
end;

procedure TDemoForm.Printbarcodeonthefly1Click(Sender: TObject);
begin
  PrintOnTheFly;
end;

procedure TDemoForm.PrintRotated;
{Print demo using barcode rotation, create barcode "on the fly"}
var
  x,y:Integer;
  xmm,ymm:Extended;
  Point:TPoint;
  MyBarcode:TBarcode;
begin
  MyBarcode:=TBarcode.create(self); {Create TBarcode object!}
  {Get the properties from the visible barcode on the screen}
  MyBarcode.Bar_caption:=Barcode1.Bar_caption;
  MyBarcode.Bar_CodeAddon:=Barcode1.Bar_CodeAddon;
  MyBarcode.Bar_Heightpercent:=Barcode1.Bar_HeightPercent;
  MyBarcode.Bar_Codetype:=Barcode1.Bar_Codetype;
  MyBarcode.Bar_Modulewidth:=Barcode1.Bar_Modulewidth;
  MyBarcode.Bar_Highdensity:=Barcode1.Bar_Highdensity;
  MyBarcode.Bar_Zoomsize:=Barcode1.Bar_Zoomsize;
  MyBarcode.Bar_WidthReduce:=Barcode1.Bar_Widthreduce;
  MyBarcode.Bar_HumanReadable:=Barcode1.Bar_HumanReadable;
  printer.begindoc;
  {Find out: How many device units are one mm}
  xmm:=getdevicecaps(Printer.Handle,logpixelsX)/25.4;
  ymm:=getdevicecaps(Printer.Handle,logpixelsY)/25.4;
  {Find out printing offset on page}
  escape(Printer.handle,Getprintingoffset,0,nil,@point);
  {Adjust printing offset, so output starts at the
   same coordinates on all printers}
  SetViewPortOrgEx(Printer.handle,-point.x,-point.y,nil);
  {Now Print the Barcode at}
  x:=round(50*Xmm);  {50mm from left}
  y:=round(60*Ymm);  {60mm from top}
  {Actual width and height of barcode are returned in "Point"}
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y);      {increment with height of barcode}
  inc(y,round(10*ymm));{increment 10mm}
  MyBarcode.Bar_rotation:=rotate_090;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y);      {increment with height of barcode}
  inc(y,round(10*ymm));{increment 10mm}
  MyBarcode.Bar_rotation:=rotate_180;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
  inc(y,Point.y);      {increment with height of barcode}
  inc(y,round(10*ymm));{increment 10mm}
  MyBarcode.Bar_rotation:=rotate_270;
  MyBarcode.Print(Printer.canvas,x,y,@Point);
{  inc(y,Point.y);      {increment with height of barcode}
{  inc(y,round(10*ymm));{increment 10mm}
  printer.enddoc;
  MyBarcode.free; {free the created TBarcode object!}
end;

procedure TDemoForm.Printrotatedbarcodes1Click(Sender: TObject);
begin
  PrintRotated;
end;

procedure TDemoForm.PrintMapmodeLLMetric;
{Set printer to different mapmode than standard, then print}
var mybarcode:TBarcode;
begin
  MyBarcode:=TBarcode.create(self); {Create TBarcode object on the fly}
  {Get the properties from the visible barcode on the screen}
  MyBarcode.Bar_caption:=Barcode1.Bar_caption;
  MyBarcode.Bar_CodeAddon:=Barcode1.Bar_CodeAddon;
  MyBarcode.Bar_Heightpercent:=Barcode1.Bar_HeightPercent;
  MyBarcode.Bar_Codetype:=Barcode1.Bar_Codetype;
  MyBarcode.Bar_Modulewidth:=Barcode1.Bar_Modulewidth;
  MyBarcode.Bar_Highdensity:=Barcode1.Bar_Highdensity;
  MyBarcode.Bar_Zoomsize:=Barcode1.Bar_Zoomsize;
  MyBarcode.Bar_WidthReduce:=Barcode1.Bar_Widthreduce;
  MyBarcode.Bar_HumanReadable:=Barcode1.Bar_HumanReadable;
  Printer.begindoc;
  {Now set another mapmode!}
  SetMapmode(Printer.Canvas.handle,mm_lometric);
  {Then print barcode}
  MyBarcode.Print(Printer.canvas,100,-300,nil);
  Printer.canvas.textout(100,-600,'Just a line of text!');
  Printer.enddoc;
  MyBarcode.free;
end;

procedure TDemoForm.Printinginmapmodemm1Click(Sender: TObject);
begin
  PrintMapmodeLLMetric;
end;

procedure TDemoForm.PrintLabelDemo;
{This code will print 6 rows of barcode labels, 2 in a row}
const
  countX=2;
  countY=6;
  leftborder=0;{mm}
  topborder=4;{mm}
  LabelWidth=105;{mm}
  LabelHeight=48;{mm}
var
  i,j,x,y:Integer;
  xmm,ymm:Extended;
  Point:TPoint;
  MyBarcode:TBarcode;
begin
  MyBarcode:=TBarcode.create(self); {Create TBarcode object!}
  With MyBarcode do {Set some default options}
  begin
    MyBarcode.Bar_Codetype:=EAN_8;
    {Set Height}
    Bar_HeightPercent:=75;
    {No high density codes,
     this is default, but for demonstration purposes...}
    Bar_HighDensity:=false;
    {Set "Normal width" which is SC2,
     this is default, but for demonstration purposes...}
    Bar_Modulewidth:=SC2;
    {With Laserprinters always use Widthreduce:=false,
     this is default, but for demonstration purposes...}
    Bar_Widthreduce:=false;
    {While printing always use Bar_ZoomSize:=false,
     this is default, but for demonstration purposes...}
    Bar_ZoomSize:=false;
    {Rotate it if You like!}
    Bar_Rotation:=rotate_000;
  end;
  printer.begindoc;
  {Find out: How many device units are one mm}
  xmm:=getdevicecaps(Printer.Handle,logpixelsX)/25.4;
  ymm:=getdevicecaps(Printer.Handle,logpixelsY)/25.4;
  {Find out printing offset on page}
  escape(Printer.handle,Getprintingoffset,0,nil,@point);
  {Adjust printing offset, so output starts at the
   same coordinates on all printers}
  SetViewPortOrgEx(Printer.handle,-point.x,-point.y,nil);
  {Now Start output loop}
  for j:=0 to CountY-1 do
  begin
    for i:=0 to CountX-1 do
    begin
      {MyBarcode.Bar_Caption:= ..... don't forget to set the Bar_Caption!}
      x:=round((Leftborder+10)*xmm+i*LabelWidth*xmm);
      y:=round((Topborder+10)*ymm+j*LabelHeight*ymm);
      MyBarcode.Print(Printer.canvas,x,y,@Point);
      y:=y+point.y;
      Printer.canvas.textout(x,y,format('This is label #%d',[j*countX+i+1]));
      {more output code if required...}
    end;
  end;
  printer.enddoc;
  MyBarcode.free; {free the created TBarcode object!}
end;

procedure TDemoForm.Labelprintingdemo1Click(Sender: TObject);
begin
  PrintLabelDemo;
end;

procedure TDemoForm.SaveBMPfile;
begin
  if savedialog1.execute then
  begin
    {Save to file with a 10 pixel frame around the barcode in just one line of code}
    Barcode1.SaveToFile(10,savedialog1.filename);
  end;
end;

procedure TDemoForm.SavebarcodetoBMPfile1Click(Sender: TObject);
begin
  SaveBMPfile;
end;

procedure TDemoForm.Copy2Clipboard;
{Copy the barcode to clipboard with just one line of code}
begin
  Barcode1.CopyToClipboard(10);{Leave 10 Pixels white frame around barcode}
  showmessage('Barcode graphic is now in the clipboard');
end;

procedure TDemoForm.Copybarcodetoclipboard1Click(Sender: TObject);
begin
  Copy2Clipboard;
end;

end.

